/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.util.datafix.fixes.EntityRenameFix;
import net.minecraft.util.datafix.fixes.References;

public class EntityZombieSplitFix
extends EntityRenameFix {
    private final Supplier<Type<?>> zombieVillagerType = Suppliers.memoize(() -> this.getOutputSchema().getChoiceType(References.ENTITY, "ZombieVillager"));

    public EntityZombieSplitFix(Schema p_15798_) {
        super("EntityZombieSplitFix", p_15798_, true);
    }

    @Override
    protected Pair<String, Typed<?>> fix(String p_341651_, Typed<?> p_341608_) {
        Typed<?> $$9;
        String $$8;
        if (!p_341651_.equals("Zombie")) {
            return Pair.of((Object)p_341651_, p_341608_);
        }
        Dynamic $$2 = (Dynamic)p_341608_.getOptional(DSL.remainderFinder()).orElseThrow();
        int $$3 = $$2.get("ZombieType").asInt(0);
        switch ($$3) {
            default: {
                String $$4 = "Zombie";
                Typed<?> $$5 = p_341608_;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                String $$6 = "ZombieVillager";
                Typed<?> $$7 = this.changeSchemaToZombieVillager(p_341608_, $$3 - 1);
                break;
            }
            case 6: {
                $$8 = "Husk";
                $$9 = p_341608_;
            }
        }
        return Pair.of((Object)$$8, (Object)$$9.update(DSL.remainderFinder(), p_341600_ -> p_341600_.remove("ZombieType")));
    }

    private Typed<?> changeSchemaToZombieVillager(Typed<?> p_341612_, int p_341675_) {
        return Util.writeAndReadTypedOrThrow(p_341612_, this.zombieVillagerType.get(), p_341611_ -> p_341611_.set("Profession", p_341611_.createInt(p_341675_)));
    }
}

